/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.dltk.compiler.task;

import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org2.eclipse.dltk.compiler.task.AbstractTodoTaskPreferences;
import org2.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org2.eclipse.dltk.compiler.task.TaskTagUtils;
import org2.eclipse.dltk.compiler.task.TodoTask;

public class TodoTaskPreferences
extends AbstractTodoTaskPreferences
implements ITodoTaskPreferences {
    private Preferences store;

    public TodoTaskPreferences(Preferences store) {
        this.store = store;
    }

    @Override
    public boolean isEnabled() {
        return this.store.getBoolean("com.aptana.editor.php.epltasks.enabled");
    }

    @Override
    public boolean isCaseSensitive() {
        return this.store.getBoolean("com.aptana.editor.php.epltasks.case_sensitive");
    }

    @Override
    protected String getRawTaskTags() {
        return this.store.getString("com.aptana.editor.php.epltasks.tags");
    }

    public void setTaskTags(List<TodoTask> elements) {
        this.store.setValue("com.aptana.editor.php.epltasks.tags", TaskTagUtils.encodeTaskTags(elements));
    }

    public static void initializeDefaultValues(Preferences store) {
        TaskTagUtils.initializeDefaultValues(store);
    }
}

